using System;

public sealed partial class SupplementaryAreasPlugin
{
    /// <summary>
    /// Represents a comment in the conversation thread for a supplementary area
    /// </summary>
    internal sealed class Comment
    {
        /// <summary>
        /// Unique identifier for the comment
        /// </summary>
        public string Id { get; set; } = string.Empty;

        /// <summary>
        /// UTC timestamp when comment was created
        /// </summary>
        public DateTime CreatedUtc { get; set; }

        /// <summary>
        /// UTC timestamp when comment was last modified (future-proof)
        /// </summary>
        public DateTime ModifiedUtc { get; set; }

        /// <summary>
        /// Person who authored the comment
        /// </summary>
        public Person? Author { get; set; }

        /// <summary>
        /// Comment text content
        /// </summary>
        public string Text { get; set; } = string.Empty;
    }
}

